/*******************************************************************************
  * @file    KungFu8_I2C.c
  * @author  ChipON Application Team
  * @version V0.0.1
  * @datef
  * @brief
  * *
  ******************************************************************************
  */
#include "includes.h"
#include "KungFu8_I2C.h"


//********************************************************************************************

s_I2C_RAMBuffer   SSCII2C_DateStruct;
//********************************************************************************************

/********************************************************************************************
*						I2C
*
*SCLӦ								SDAӦ
*  P1.0									P1.1
*  P0.2									P0.1
*
**********************************************************************************************/

/***********************************************************************************
 *      	I2C_Delayus
 * 	ʱʱ
 * ڲ	ʱʱdealy_us
 *          
 *
 **********************************************************************************/
#define I2C_Delayus(delay_us)  Delay_Wait_CLK_Sample(delay_us)

/***********************************************************************************
 *      	I2C_Idle
 * 	ȴI2Cģ(ģʽ)
 * ڲ	
 *          
 * ȴI2Cģ(ģʽ)
 **********************************************************************************/
void	I2C_Idle(void)
{
	// еӦδɡտСֹͣ,ͽ
	while(  SSCI1CTL2&0x1F || SSCI1RW );
	SSCI1IF=0;
	BCL1IF=0;      //߳ͻж
}
/***********************************************************************************
 *      	I2C_Start
 * 	I2C(ģʽ)
 * ڲ	
 *          
 * I2C
 **********************************************************************************/
void I2C_Start(void)
{
	I2C_Idle();				// ȴI2C
	STARTEN1=1; 				// ʼI2Cģʽ
	while(STARTEN1); 		// ȴʼ
	SSCI1IF=0;  				// ʼɵı
	I2C_Delayus(10);  		// ʹжϵӦʱ䣬ݴӻӦٶ
}
/***********************************************************************************
 *      	I2C_ReStart
 * 	I2C(ģʽ)
 * ڲ	
 *          
 * I2C
 **********************************************************************************/
void I2C_ReStart(void)
{
	I2C_Idle();     //ȴ
	RESTARTEN1=1;
	while(RESTARTEN1);
	SSCI1IF=0;
}
/***********************************************************************************
 *      	I2C_Stop
 * 	ֹͣI2C(ģʽ)
 * ڲ	
 *          
 * I2Cֹͣ
 **********************************************************************************/
void I2C_Stop(void)
{
	I2C_Idle();				// ȴI2C
	STOPEN1=1;
	while(STOPEN1);
	SSCI1IF=0;
	I2C_Delayus(10);  		// ʹֹͣжϵӦʱ䣬ݴӻӦٶ
}
/***********************************************************************************
 *      	I2C_SendAck
 * 	I2CӦ(ģʽ)
 * ڲ	
 *          
 * I2CӦ  0Ӧ  1Ӧ
 **********************************************************************************/


void I2C_RSendXAck()
{
//	// Ӧ,ǰ
//	SSCI1ACKDAT=0;
//	SSCI1ACKDAT=1;
	// Ӧ
	SSCI1ACKEN=1;
	// ȴӦ
	while(SSCI1ACKEN);
	// Ӧյжϱ־
	SSCI1IF=0;
}

void I2C_SendAck()
{
	// Ӧ
	SSCI1ACKDAT=0;
	// ʹӦ
	SSCI1ACKEN=1;
	// ȴӦ
	while(SSCI1ACKEN);
	// Ӧյжϱ־
	SSCI1IF=0;
}

void I2C_SendNAck()
{
	// Ӧ
	SSCI1ACKDAT=1;
	// ʹӦ
	SSCI1ACKEN=1;
	// ȴӦ
	while(SSCI1ACKEN);
	// Ӧյжϱ־
	SSCI1IF=0;
}
/***********************************************************************************
 *      	I2C_SendData
 * 	I2C͵ֽ(ģʽ)
 * ڲ	͵ĵֽData
 *          
 * I2C
 **********************************************************************************/
void I2C_SendData(uint8 sData)
{
//	// жҲǴģֱд д㣬߼дͻ
//	SSCIWCFL=0;
//	// ȷжϱ־
//	SSCIIF=0;
//	// 
//	SSCIBUFR=sData;
//	while (!SSCIIF);//ȴ,ΪҪʶӻӦ״̬ȴbit9ŽͺǷ״̬յSSCIBUF
//	SSCIIF=0;


//::	ע߼⣬ΪŻR0ֱʹ
//::	    Ὣ   SSCIBUFR=Data;ִУSSCIWCFL=0;SSCIIF=0;ִ
//::	 Ҫ߼volatile uint8 ľֲתֵ
//::	volatile uint8 sdatabuf=sData,   SSCIBUFR=sdatabuf  ںʧЧ

//		volatile uint8 sdatabuf=sData;
//		// жҲǴģֱд д㣬߼дͻ
//		SSCIWCFL=0;
//		// ȷжϱ־
//		SSCIIF=0;
//		// 
//		SSCIBUFR=sdatabuf;
//		while (!SSCIIF);//ȴɣΪҪʶӻӦ״̬ȴbit9ŽͺǷ״̬յSSCIBUF
//		SSCIIF=0;

	SSCI1BUFR=sData;   // дͻ,״̬SSCIIF=0
	while (!SSCI1IF);
	SSCI1WCFL=0;	  // дͻֱ
	SSCI1IF=0;		  // һ㲻ж
}
/***********************************************************************************
 *      	I2C_ReceiveData
 * 	I2C(ģʽ)
 * ڲ	
 *          յĵֽRecdata
 * I2C
 **********************************************************************************/
uint8 I2C_ReceiveData(void)
{
	// жҲǴģֱ־
	SSCI1OV=0;
	//  ʹ
	SSCI1RCEN=1;
	// жɵĽ
	while(!SSCI1IF);
	SSCI1IF=0;
	// ݣϲӦÿǷݵӦ
	return SSCI1BUFR;
}

/***********************************************************************************
 *      	I2C_Write_Data
 * 	ӻ·д(ģʽ)
 * ڲ	SSCII2C_DateStruct
 *          
 *
 **********************************************************************************/
uint8  I2C_Write_s_Data()
{
	uint8   i;
	// жϿģʽ
	I2C_Idle();				// ȴI2C
	// I2C,Ǹʵӳ
	I2C_Start();
	//============================================
	// д ӻַ
	if(isSampleMode10bits)
	{// 10bit
		I2C_SendData(SSCII2C_DateStruct.i2cDevAddrH);  if(SSCI1ACKSTA) goto write_s_end_I2C_Write_s_Data;
		I2C_SendData(SSCII2C_DateStruct.i2cDevAddrL);  if(SSCI1ACKSTA) goto write_s_end_I2C_Write_s_Data;
	}
	else
	{// 7bit
		I2C_SendData(SSCII2C_DateStruct.i2cDevAddrL);  if(SSCI1ACKSTA)  goto write_s_end_I2C_Write_s_Data;
	}
	//============================================
	// ַ Դַ
	I2C_SendData(SSCII2C_DateStruct.Command );  	   if(SSCI1ACKSTA)  goto write_s_end_I2C_Write_s_Data;
	//============================================
	// дݣbuffer10ֽڵ
	for(i=0;i<SSCII2C_DateStruct.length;i++)
	{
		I2C_SendData(SSCII2C_DateStruct.buffer[i]);	   if(SSCI1ACKSTA)  goto write_s_end_I2C_Write_s_Data;
	}
	// ͽ
	I2C_Stop();
	return (0);
write_s_end_I2C_Write_s_Data:
	I2C_Stop();
	return (1);  //ӻδӦ𣬷1
}
/***********************************************************************************
 *      	I2C_Write_Data
 * 	ӻ·д(ģʽ)
 * ڲ	ӻĿַҪд볤ȣָ
 *          
 *
 **********************************************************************************/
uint8  I2C_Write_Data(uint8 cAddr,uint8 Length,uint8 * DataAddressPoint)
{
	uint8   i;
	// жϿģʽ
	I2C_Idle();				// ȴI2C
	//============================================
	// I2C,Ǹʵӳ
	I2C_Start();
	//============================================
	// д ӻַ
	if(isSampleMode10bits)
	{// 10bit
		I2C_SendData(I2C_Add_H | 0x00);  	if(SSCI1ACKSTA) goto write_p_end_I2C_Write_Data;
		I2C_SendData(I2C_Add_L);		  	if(SSCI1ACKSTA) goto write_p_end_I2C_Write_Data;
	}
	else
	{// 7bit
		I2C_SendData(I2C_Add_L | 0x00);		 if(SSCI1ACKSTA) goto write_p_end_I2C_Write_Data;
	}
	//============================================
	// ַ Դַ
	I2C_SendData(cAddr );					  if(SSCI1ACKSTA) goto write_p_end_I2C_Write_Data;
	//============================================
	// д
	for(i=0;i<Length;i++)
	{
		I2C_SendData(*(DataAddressPoint+i));	  if(SSCI1ACKSTA) goto write_p_end_I2C_Write_Data;
	}
	// ͽ
	I2C_Stop();
	return (0);
write_p_end_I2C_Write_Data:
	I2C_Stop();
	return (1);
}
/***********************************************************************************
 *      	I2C_Read_s_Data
 * 	Ӵӻ¶ȡ(ģʽ)
 * ڲ	SSCII2C_DateStruct
 *          
 *
 **********************************************************************************/
uint8  I2C_Read_s_Data()
{
	uint8   i;
	// жϿģʽ
	I2C_Idle();				// ȴI2C
	// I2C,Ǹʵӳ
	I2C_Start();
	//============================================ дַ λַ
	// д ӻַ
	if(isSampleMode10bits)
	{// 10bit
		I2C_SendData(SSCII2C_DateStruct.i2cDevAddrH);  if(SSCI1ACKSTA)  goto read_s_end_I2C_Read_s_Data;
		I2C_SendData(SSCII2C_DateStruct.i2cDevAddrL);  if(SSCI1ACKSTA)  goto read_s_end_I2C_Read_s_Data;
	}
	else
	{// 7bit
		I2C_SendData(SSCII2C_DateStruct.i2cDevAddrL);  if(SSCI1ACKSTA)  goto read_s_end_I2C_Read_s_Data;
	}
	//============================================
	// ַ Դַ
	I2C_SendData(SSCII2C_DateStruct.Command );  		if(SSCI1ACKSTA)  goto read_s_end_I2C_Read_s_Data;
	//============================================   ׼ȡ
	// ȡģʽ
	I2C_ReStart();
	//============================================   ӻѰַĶ
	// д ӻַ
	if(isSampleMode10bits)
	{// 10bit
		I2C_SendData(SSCII2C_DateStruct.i2cDevAddrH|0x01);  if(SSCI1ACKSTA)  goto read_s_end_I2C_Read_s_Data;
	 // ģʽSSCIUAźţʽݸߵַȡģʽ״̬תˡҪ͵λַ
	}
	else
	{// 7bit
		I2C_SendData(SSCII2C_DateStruct.i2cDevAddrL|0x01);  if(SSCI1ACKSTA)  goto read_s_end_I2C_Read_s_Data;
	}
	//============================================  µѭȡ
	// ݵĶȡ
	for(i=0;i<SSCII2C_DateStruct.length;i++)
	{
		SSCII2C_DateStruct.buffer[i]=I2C_ReceiveData();     //ReceiveData()SSCIBUFR

		// ȡ1Ӧ𣬷Ӧ
		if(i==(SSCII2C_DateStruct.length-1))
		{
			SSCI1ACKDAT=1;  // Ӧ  1α벻Ӧ𣬷ֹͣ󣬺i2c
		}
		else
		{
			SSCI1ACKDAT=0;  // Ӧ
		}
		I2C_RSendXAck();
	}
	// ͽ
	I2C_Stop();
	return (0);
read_s_end_I2C_Read_s_Data:
	I2C_Stop();
	return (1);
}
/***********************************************************************************
 *      	I2C_Read_Data
 * 	Ӵӻ¶ȡ(ģʽ)
 * ڲ	ӻĿַҪд볤ȣָ
 *          
 *
 **********************************************************************************/
uint8 I2C_Read_Data(uint8 cAddr,uint8 Length,uint8 * TempAddressPoint)
{
	uint8   i;

	// жϿģʽ
	I2C_Idle();			// ȴI2C
	// I2C,Ǹʵӳ
	I2C_Start();
	//============================================ дַ λַ
	// д ӻַ
	if(isSampleMode10bits)
	{// 10bit
		I2C_SendData(I2C_Add_H | 0x00);  	if(SSCI1ACKSTA) goto read_p_end_I2C_Read_Data;
		I2C_SendData(I2C_Add_L);  			if(SSCI1ACKSTA) goto read_p_end_I2C_Read_Data;
	}
	else
	{// 7bit
		I2C_SendData(I2C_Add_L | 0x00);  	if(SSCI1ACKSTA) goto read_p_end_I2C_Read_Data;
	}
	//============================================
	// ַ Դַ
	I2C_SendData(cAddr);  					if(SSCI1ACKSTA) goto read_p_end_I2C_Read_Data;
	//============================================  ׼ȡ
	// ȡģʽ
	I2C_ReStart();
	//============================================   ӻѰַĶ
	// Ͷ ӻַ
	if(isSampleMode10bits)
	{// 10bit
		I2C_SendData(I2C_Add_H | 0x01);		  if(SSCI1ACKSTA) goto read_p_end_I2C_Read_Data;
		// ģʽSSCIUAźţʽݸߵַȡģʽ״̬תˡҪ͵λַ
	}
	else
	{// 7bit
		I2C_SendData(I2C_Add_L | 0x01);		  if(SSCI1ACKSTA) goto read_p_end_I2C_Read_Data;
	}
	//============================================  µѭȡ
	// ݵĶȡ
	for(i=0;i<Length;i++)
	{
		TempAddressPoint[i]=I2C_ReceiveData();
		// ȡ1Ӧ𣬷Ӧ
		if(i==(Length-1))
		{
			SSCI1ACKDAT=1;  // Ӧ  1α벻Ӧ𣬷ֹͣ󣬺i2c
		}
		else
		{
			SSCI1ACKDAT=0;  // Ӧ
		}
		I2C_RSendXAck();
	}
	// ͽ
	I2C_Stop();
	return (0);
read_p_end_I2C_Read_Data:
	I2C_Stop();
	return (1);
}
/***********************************************************************************
 *      	I2C_Configuration
 * 	I2C ģʽĳʼܺ
 * ڲ	
 *          
 *
 **********************************************************************************/
void I2C_Configuration_Slave(void)
{
	// ҪȹرSSCI1I2Cģ
	SSCI1EN=0;
	// ģΪ룬ѡP02P01
	APFCTL10 &= 0x0F;
	APFCTL10 |= 0x50; 		 //ܽŸSCL:P02 SDA:P01
	ANS01=0;	ANS02=0;
	TR01=1;		TR02=1;

//#####################   ӻģʽ   #######################################
	// 㲥ʹ
	SSCI1CALLEN=0;
	// 
	SSCI1CTL0=I2C_SSCIMSK_RW_Enabled;  // ѡʹĴ,ֲ
	SSCI1MSK=0x00;  // bit0λƥ
	// Ҫ룬bitλ   ӻЧ

	if(isSampleMode10bits)
	{// 10bit
		SSCI1CTL0=I2C_Slave_Mode_Address_10Bits;
		// SSCIADD  ȸߵַȴƥ
		SSCI1ADD=I2C_Add_H;
		Mode10bitsAddrUAState=0;
	}
	else
	{// 7bit
		SSCI1CTL0=I2C_Slave_Mode_Address_7Bits;
		// SSCIADD
		SSCI1ADD=I2C_Add_L;
	}
	// ־ͿĬλ
	SSCI1STA=0x00;

	// жϵʹ
		BCL1IF=0;
		SSCI1IF=0;
		BCL1IE=0;
		SSCI1IE=1;
//		PBCL=1;
//		PSSCI=1;

	// ʹģĹ
		SSCI1CKP=1;  //  =1  SCKͷţʹʱ   Ӧ ʱ ȴϵĸ1ʹʱӼ
		SSCI1EN=1;
}
void I2C_Configuration_Master(void)
{
	// ҪȹرI2Cģ
	SSCI1EN=0;
	// ģΪ룬ѡP02P01
	APFCTL10 &= 0x0F;
	APFCTL10 |= 0x50; 		 //ܽŸSCL:P02 SDA:P01
	ANS02=0;	ANS01=0;
	TR02=1;		TR01=1;
//#####################   ģʽ   #######################################
	// ΪӦÿ쳣9bitĴӻӦԣɿƽٶCLK9Ӻ豸λƻ
	// Ϊӻ豸CLK9ӦΪDATȴCLK9½ͷDATCLK9쳣£ӻDAT豸
	// ʼӦģһCLK9½أģֹͣźţʹܴӻ쳣лָӦ

	TR02=0; P0LR2=0;
	I2C_Delayus(100); // ӻ֧ʱӵٶȵʱ

	TR01=0; P0LR1=0;
	I2C_Delayus(100);

	P0LR2=1;
	I2C_Delayus(100); // ӻ֧ʱӵٶȵʱ

	P0LR1=1;
	I2C_Delayus(100);

	TR02=1;TR01=1;

	//----------------------------------
	SSCI1ADD=79;//ģʽ£üĴ ʱ=SCLK/(4*(SSCIxADD+1))˲ 39-100K,79-50K;
	// SCLʱʹܿ        ģʽ
	SSCI1CTL0=0x10 | I2C_Master_Mode_SCL_UserDefined;
	SSCI1CTL1=0;
	// ־ͿĬλ
	SSCI1STA=0x00;

	// жϵʹ
	BCL1IF=0;				//߳ͻжϱ־λ
	SSCI1IF=0;
	BCL1IE=0;
	SSCI1IE=0;
//	PBCL=1;
//	PSSCI=1;

	// ʹģĹ
	SSCI1EN=1;

}

